/* vim: set sw=8 ts=8 si et: */
/*********************************************
* Serial Peripheral Interface 
* Author: Guido Socher, Copyright: GPL 
* Copyright: GPL
**********************************************/
#include <avr/io.h>
#include "avr_compat.h"
#include "timeout.h"
static unsigned char sck_dur=2;

// set the speed (used by PARAM_SCK_DURATION, page 31 in AVR068)
// For a clock of 3.6864MHz this is:
// SPI2X SPR1 SPR0 divider result_spi_Freq
//  0     0    0     f/4      921KHz : sckdur =0
//  0     0    1     f/16     230KHz : sckdur =1
//  0     1    0     f/64     57KHz  : sckdur =2
//  0     1    1     f/128    28KHz  : sckdur =3
//
//SPI2X=SPSR bit 0
//SPR0 and SPR1 =SPCR bit 0 and 1
unsigned char  spi_set_sck_duration(unsigned char dur)
{
        if (dur >= 3){
        	// 28KHz
        	cbi(SPSR,SPI2X);
        	sbi(SPCR,SPR0);
        	sbi(SPCR,SPR1);
                sck_dur=3;
        	return(sck_dur);
        }
        if (dur == 2){
        	// 57KHz
        	cbi(SPSR,SPI2X);
        	sbi(SPCR,SPR0);
        	cbi(SPCR,SPR1);
                sck_dur=2;
        	return(sck_dur);
        }
        if (dur == 1){
        	// 230KHz
        	cbi(SPSR,SPI2X);
        	cbi(SPCR,SPR0);
        	sbi(SPCR,SPR1);
                sck_dur=1;
        	return(sck_dur);
        }
        if (dur == 0){
        // 921KHz
                cbi(SPSR,SPI2X);
                cbi(SPCR,SPR0);
                cbi(SPCR,SPR1);
                sck_dur=0;
                return(sck_dur);
        }
        return(4); // we should never come here
}

unsigned char spi_get_sck_duration(void)
{
        return(sck_dur);
}

void spi_init(void) 
{
        unsigned char ci;
        sbi(DDRB,PB2); // pb2 as reset pin is output
        cbi(PORTB,PB2); // reset = low = active
        delay_ms(2);
        cbi(PORTB,PB3); // MOSI low
        cbi(PORTB,PB5); // SCK low
        //
        sbi(DDRB,PB3); // MOSI is output
        sbi(DDRB,PB5); // SCK is output
        cbi(DDRB,PB4); // MISO is input
        /* Enable SPI, Master, set clock rate fck/16 */
        SPCR = (1<<SPE)|(1<<MSTR)|(1<<SPR0);
        //
        sbi(PORTB,PB2); // reset = high
        // 200 micro sec:
        for(ci=0;ci<200;ci++) asm("nop");
        cbi(PORTB,PB2); // reset = low, stay active
        delay_ms(2);
        // read from eeprom in later versions:
        spi_set_sck_duration(2);
}

// send 8 bit, return received byte
unsigned char spi_mastertransmit(unsigned char data)
{
        /* Start transmission */
        SPDR = data;
        /* Wait for transmission complete */
        while(!(SPSR & (1<<SPIF)));
        return(SPDR);
}

// send 16 bit, return last rec byte
unsigned char spi_mastertransmit_16(unsigned int data)
{
        spi_mastertransmit((data>>8)&0xFF);
        return(spi_mastertransmit(data&0xFF));
}

// send 32 bit, return last rec byte
unsigned char spi_mastertransmit_32(unsigned long data)
{
        spi_mastertransmit((data>>24)&0xFF);
        spi_mastertransmit((data>>16)&0xFF);
        spi_mastertransmit((data>>8)&0xFF);
        return(spi_mastertransmit(data&0xFF));
}


void spi_disable(void)
{
        SPCR=0x00;     // SPI off
        sbi(PORTB,PB2);// reset = high, off
        cbi(DDRB,PB3); // MOSI high impedance, input
        cbi(DDRB,PB5); // SCK high impedance, input
}

